varying vec2 		texcoord;
uniform sampler2D 	tex;
uniform vec3		color;
uniform vec4		colorMul;

#ifdef PSYSTEM

#ifdef DEFERRED
	uniform sampler2D 	depthBG;
#endif
varying	float 		life;
uniform vec4 		particleFade;
varying vec4 		pos;
varying vec4		tpos;

#endif

uniform float 		alpha;

void main()
{
#ifdef PSYSTEM

	float plife=life;
	if(plife>0.0)
	{
		#ifdef DEFERRED
			vec2 UV=(pos.xy/pos.w)*0.5+0.5;
			float sceneDepth=texture2D(depthBG,UV.st).r;
			float alphaDepth=clamp((tpos.z-sceneDepth)*0.003125,0.0,1.0);
			/*if(alphaDepth<=0.0)
				discard;*/
		#else
			float alphaDepth=1.0;
		#endif
		vec4 c=texture2D(tex,texcoord);	
		c.rgb=pow(c.rgb,vec3(2.2));
		c.rgb*=color.rgb;
		float pl=1.0-life;
		float fin=min(pl/particleFade.x,1.0);      
		float fout=1.0-min(max(pl-(1.0-particleFade.y),0.0)/particleFade.y,1.0);
		c.a*=(fin*fout);
		
		c.a*=alpha*alphaDepth;
		gl_FragColor = c;
	}
	else
		discard;
	
#else
	
	vec4 c=texture2D(tex,texcoord);	
	c.rgb*=pow(color.rgb,vec3(2.2))*colorMul.a;//*scale;
	
	c.a*=alpha;
	gl_FragColor = c;
	
#endif
	
}
